<?php

namespace pluxix\Client;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Autoloader {
	public static function register(): void {
		spl_autoload_register( array( __CLASS__, 'autoload' ) );
	}

	public static function autoload( string $class ): void {
		$prefix = 'pluxix\\Client\\';
		if ( 0 !== strpos( $class, $prefix ) ) {
			return;
		}

		$relative = substr( $class, strlen( $prefix ) );
		$relative = str_replace( '\\', '/', $relative );

		$parts = explode( '/', $relative );
		$filename_part = array_pop( $parts );
		$filename = 'class-' . strtolower( str_replace( '_', '-', $filename_part ) ) . '.php';

		$base = pluxix_CLIENT_PATH . 'includes/';
		$dir = '';
		if ( ! empty( $parts ) ) {
			$dir = strtolower( implode( '/', $parts ) ) . '/';
		}

		$path = $base . $dir . $filename;
		if ( file_exists( $path ) ) {
			require_once $path;
		}
	}
}
