<?php

namespace pluxix\Client;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Installer {
	public static function activate(): void {
		// Settings UI has been removed; only keep internal maps.
		$map = get_option( 'pluxix_client_map', array() );
		if ( ! is_array( $map ) ) {
			$map = array();
		}
		$map = wp_parse_args(
			$map,
			array(
				'plugins' => array(),
				'themes'  => array(),
			)
		);
		update_option( 'pluxix_client_map', $map );

		// Restore cron scheduling if Auto Update was enabled.
		$enabled = (bool) get_option( 'pluxix_client_auto_update_enabled', false );
		if ( $enabled ) {
			Cron::ensure_scheduled();
		}

		Reporter::activate();
	}

	public static function deactivate(): void {
		Cron::unschedule();
		Reporter::deactivate();
	}
}
