<?php

namespace pluxix\Client;

use pluxix\Client\Admin\Admin;
use pluxix\Client\Admin\Ajax;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Plugin {
	private static $instance = null;

	public static function instance(): self {
		if ( null === self::$instance ) {
			self::$instance = new self();
		}
		return self::$instance;
	}

	private function __construct() {
		add_action( 'plugins_loaded', array( $this, 'load_textdomain' ) );
		Cron::instance();
		Reporter::init();

		if ( is_admin() ) {
			Admin::instance();
			Ajax::instance();
		}
	}

	public function load_textdomain(): void {
		load_plugin_textdomain(
			'pluxix-client',
			false,
			dirname( pluxix_CLIENT_BASENAME ) . '/languages'
		);
	}
}
