<?php
/**
 * Plugin Name: PLUXIX Client
 * Description: PLUXIX Client - install and upgrade premium plugin and themes instantly
 * Version: 1.1.0
 * Author: PLUXIX
 * Author URI: https://pluxix.com/
 * Text Domain: pluxix-client
 * Domain Path: /languages
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

define( 'pluxix_CLIENT_VERSION', '1.1.0' );
define( 'pluxix_CLIENT_PATH', plugin_dir_path( __FILE__ ) );
define( 'pluxix_CLIENT_URL', plugin_dir_url( __FILE__ ) );
define( 'pluxix_CLIENT_BASENAME', plugin_basename( __FILE__ ) );

// Server URL is intentionally obfuscated (Base64) to avoid exposing it in the UI.
define( 'pluxix_CLIENT_SERVER_URL_B64', 'aHR0cHM6Ly9wbHV4aXguY29t' );

require_once pluxix_CLIENT_PATH . 'includes/class-autoloader.php';
\pluxix\Client\Autoloader::register();

register_activation_hook(
	__FILE__,
	static function () {
		\pluxix\Client\Installer::activate();
	}
);

register_deactivation_hook(
	__FILE__,
	static function () {
		\pluxix\Client\Installer::deactivate();
	}
);

add_action(
	'plugins_loaded',
	static function () {
		\pluxix\Client\Plugin::instance();
	}
);
